/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;

public class MobiBrowser
extends MIDlet {
    static final Command BACK_CMD = new Command("Back", 2, 1);
    static final Command STOP_CMD = new Command("Stop", 2, 1);
    static final Command QUIT_CMD = new Command("Quit", 3, 2);
    static final Command GOTO_CMD = new Command("Go to", 1, 1);
    static final Command ADD_CMD = new Command("Add", 1, 2);
    static final Command RENAME_CMD = new Command("Rename", 1, 1);
    static final Command REMOVE_CMD = new Command("Delete", 1, 3);
    static final Command SEARCH_CMD = new Command("Search", 1, 2);
    static final Command HELP_CMD = new Command("Help", 1, 3);
    static final String STORE_NAME = "BOOKMARKS";
    static final int CACHE_SIZE_PAGES = 2;
    static final int CACHE_SIZE_BYTES = 65536;
    Vector bookmarks = new Vector();
    Vector history = new Vector();
    History current;
    Hashtable historyHash = new Hashtable();
    RecordStore store;
    Menu menu;
    Hashtable cacheHash;
    CacheEntry lru;
    int cacheSizePages = 2;
    int cacheSizeBytes = 65536;
    int cacheUsedBytes;
    int cacheUsedPages;

    public void addBookmark(Bookmark bookmark) {
        int n = this.bookmarks.size();
        for (int i = 0; i < n; ++i) {
            if (!bookmark.equals(this.bookmarks.elementAt(i))) continue;
            Bookmark bookmark2 = (Bookmark)this.bookmarks.elementAt(i);
            bookmark2.pos = bookmark.pos;
            bookmark2.url = bookmark.url;
            this.updateBookmark(bookmark2);
            return;
        }
        this.bookmarks.addElement(bookmark);
        byte[] byArray = bookmark.pack();
        try {
            bookmark.id = this.store.addRecord(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateBookmark(Bookmark bookmark) {
        byte[] byArray = bookmark.pack();
        try {
            this.store.setRecord(bookmark.id, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeBookmark(int n) {
        try {
            this.store.deleteRecord(((Bookmark)this.bookmarks.elementAt((int)n)).id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bookmarks.removeElementAt(n);
    }

    private void openStore() {
        try {
            this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            int n = this.store.getNextRecordID();
            if (n == 1) {
                for (int i = 0; i < Locale.PREDEFINED_BOOKMARKS.length; ++i) {
                    this.addBookmark(Locale.PREDEFINED_BOOKMARKS[i]);
                }
            } else {
                for (int i = 1; i < n; ++i) {
                    try {
                        this.bookmarks.addElement(new Bookmark(i, this.store.getRecord(i)));
                        continue;
                    }
                    catch (InvalidRecordIDException invalidRecordIDException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeStore() {
        if (this.store != null) {
            try {
                this.store.closeRecordStore();
                this.store = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String removeHttpPrefix(String string) {
        int n = string.indexOf(58);
        return string.substring(n + 3);
    }

    public static String getHost(String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf(47, n + 3);
        if (n2 < 0) {
            n2 = n + 3;
        }
        return string.substring(0, n2);
    }

    public static String getBaseUrl(String string) {
        return string.substring(0, string.lastIndexOf(47) + 1);
    }

    public void load(String string, int n) {
        CacheEntry cacheEntry;
        if (this.cacheSizePages > 0 && (cacheEntry = (CacheEntry)this.cacheHash.get(string)) != null) {
            cacheEntry.unlink();
            this.lru.link(cacheEntry);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)cacheEntry.canvas);
            return;
        }
        new ConnectForm(string, n, this);
    }

    public void forward() {
        if (this.current != null && this.current.forward != null) {
            this.current = this.current.forward;
            this.load(this.current.url, this.current.pos);
        }
    }

    public void backward() {
        if (this.current != null && this.current.backward != null) {
            this.current = this.current.backward;
            this.load(this.current.url, this.current.pos);
        }
    }

    public void setCurrentPosition(int n) {
        this.current.pos = n;
        this.addBookmark(new Bookmark(n, "Last", this.current.url));
    }

    public MobiBrowser() {
        if (this.cacheSizePages > 0) {
            this.lru.next = this.lru.prev = (this.lru = new CacheEntry());
            this.cacheHash = new Hashtable();
        }
        this.openStore();
    }

    public void error(String string) {
        this.error(string, (Displayable)this.menu);
    }

    public void error(String string, Displayable displayable) {
        Alert alert = new Alert("Error", string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent(alert, displayable);
    }

    protected void destroyApp(boolean bl) {
        this.closeStore();
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        this.menu = new Menu(this, null);
    }

    public void quit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void cache(String string, ReaderCanvas readerCanvas) {
        History history = new History();
        history.url = string;
        history.backward = this.current;
        if (this.current != null) {
            this.current.forward = history;
        }
        this.current = history;
        this.history.addElement(history);
        this.historyHash.put(string, history);
        if (this.cacheSizePages > 0) {
            CacheEntry cacheEntry = (CacheEntry)this.cacheHash.get(string);
            if (cacheEntry == null) {
                this.cacheUsedBytes += readerCanvas.textLength;
                ++this.cacheUsedPages;
                if (!(this.lru.isEmpty() || this.cacheUsedPages <= this.cacheSizePages && this.cacheUsedBytes <= this.cacheSizeBytes)) {
                    do {
                        cacheEntry = this.lru.prev;
                        cacheEntry.unlink();
                        this.cacheHash.remove(cacheEntry.url);
                        this.cacheUsedBytes -= cacheEntry.canvas.textLength;
                        --this.cacheUsedPages;
                        cacheEntry.canvas = null;
                    } while (!this.lru.isEmpty() && this.cacheUsedBytes > this.cacheSizeBytes);
                } else {
                    cacheEntry = new CacheEntry();
                }
                cacheEntry.url = string;
                this.cacheHash.put(string, cacheEntry);
            } else {
                cacheEntry.unlink();
            }
            cacheEntry.canvas = readerCanvas;
            this.lru.link(cacheEntry);
        }
    }

    static class History {
        String url;
        int pos;
        History forward;
        History backward;

        History() {
        }
    }

    static class CacheEntry {
        CacheEntry next;
        CacheEntry prev;
        String url;
        ReaderCanvas canvas;

        CacheEntry() {
        }

        void link(CacheEntry cacheEntry) {
            cacheEntry.next = this.next;
            this.next.prev = cacheEntry;
            cacheEntry.prev = this;
            this.next = cacheEntry;
        }

        void unlink() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
        }

        boolean isEmpty() {
            return this.next == this;
        }
    }
}

