/*
 * Decompiled with CFR 0.152.
 */
import java.io.UnsupportedEncodingException;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class WebSearchForm
extends Form
implements CommandListener {
    Menu menu;
    TextField query;
    ChoiceGroup scope;
    static String queryText;
    static final int MAX_QUERY_LENGTH = 128;
    static String URL;

    WebSearchForm(Menu menu) {
        super("Web search");
        this.menu = menu;
        this.addCommand(MobiBrowser.SEARCH_CMD);
        this.addCommand(MobiBrowser.BACK_CMD);
        this.query = new TextField(null, queryText, 128, 0);
        this.append((Item)this.query);
        this.scope = new ChoiceGroup("Search in", 1, new String[]{"Internet", "English"}, null);
        this.append((Item)this.scope);
        this.setCommandListener(this);
        Display.getDisplay((MIDlet)menu.browser).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == MobiBrowser.SEARCH_CMD) {
            byte[] byArray;
            queryText = this.query.getString().trim();
            if (queryText.length() == 0) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(URL);
            stringBuffer.append("hl=");
            stringBuffer.append("en");
            stringBuffer.append("&q=");
            try {
                byArray = queryText.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = queryText.getBytes();
            }
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                if (by < 0) {
                    stringBuffer.append('%');
                    stringBuffer.append(Integer.toHexString(by & 0xFF));
                    continue;
                }
                if (by == 32) {
                    stringBuffer.append("%20");
                    continue;
                }
                stringBuffer.append((char)by);
            }
            stringBuffer.append("&lr=");
            if (this.scope.getSelectedIndex() != 0) {
                stringBuffer.append("lang_");
                stringBuffer.append("en");
            }
            new ConnectForm(stringBuffer.toString(), 0, this.menu.browser);
            return;
        }
        Display.getDisplay((MIDlet)this.menu.browser).setCurrent((Displayable)this.menu);
    }

    static {
        URL = "www.google.com/search?";
    }
}

